VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Time Interval and KPCI-3140"
   ClientHeight    =   7575
   ClientLeft      =   1830
   ClientTop       =   1755
   ClientWidth     =   8745
   LinkTopic       =   "Form1"
   ScaleHeight     =   7575
   ScaleWidth      =   8745
   Begin VB.TextBox txtDIFF 
      Enabled         =   0   'False
      Height          =   285
      Left            =   7200
      TabIndex        =   21
      Top             =   1560
      Width           =   855
   End
   Begin VB.TextBox txtCT1 
      Enabled         =   0   'False
      Height          =   285
      Left            =   6000
      TabIndex        =   20
      Top             =   1560
      Width           =   855
   End
   Begin VB.TextBox txtCT0 
      Enabled         =   0   'False
      Height          =   285
      Left            =   4920
      TabIndex        =   19
      Top             =   1560
      Width           =   735
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   375
      Left            =   6480
      TabIndex        =   14
      Top             =   6600
      Width           =   1575
   End
   Begin VB.CommandButton cmdHelp 
      Caption         =   "Wiring Help"
      Height          =   375
      Left            =   6480
      TabIndex        =   13
      Top             =   6000
      Width           =   1575
   End
   Begin VB.TextBox txtDuration 
      Height          =   375
      Left            =   3600
      TabIndex        =   11
      Text            =   "500"
      ToolTipText     =   "For the 1KHz timebase used, can be no longer than 65535"
      Top             =   2160
      Width           =   615
   End
   Begin VB.Timer Timer1 
      Left            =   5640
      Top             =   240
   End
   Begin VB.CommandButton cmdTriggers 
      Caption         =   "Generate Start/Stop Trigger Pulses"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   1320
      TabIndex        =   10
      Top             =   2760
      Width           =   3015
   End
   Begin DlsrLib.DriverLINXSR SR_DO 
      Left            =   5040
      Top             =   240
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR_SqWave 
      Left            =   4440
      Top             =   240
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.CommandButton Command4 
      Caption         =   "stop"
      Enabled         =   0   'False
      Height          =   375
      Left            =   1320
      TabIndex        =   3
      Top             =   3360
      Width           =   3015
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Start"
      Enabled         =   0   'False
      Height          =   375
      Left            =   1320
      TabIndex        =   2
      Top             =   1560
      Width           =   3015
   End
   Begin VB.TextBox Text1 
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   420
      Left            =   4920
      TabIndex        =   1
      Text            =   "Time Value"
      Top             =   2160
      Width           =   3015
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Configure"
      Enabled         =   0   'False
      Height          =   375
      Left            =   1320
      TabIndex        =   0
      Top             =   960
      Width           =   3015
   End
   Begin DlsrLib.DriverLINXSR DriverLINXSR1 
      Left            =   3840
      Top             =   240
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label9 
      AutoSize        =   -1  'True
      Caption         =   "Step 4:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   480
      TabIndex        =   18
      ToolTipText     =   "Arm the DO bits to Start and Stop the Counters"
      Top             =   2880
      Width           =   630
   End
   Begin VB.Label Label8 
      AutoSize        =   -1  'True
      Caption         =   "Step 3:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   480
      TabIndex        =   17
      ToolTipText     =   "Select a Time Duration to Simulate"
      Top             =   2280
      Width           =   630
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "Step 2:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   480
      TabIndex        =   16
      ToolTipText     =   "Arm Counters 0 and 1"
      Top             =   1560
      Width           =   630
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Step 1:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   480
      TabIndex        =   15
      ToolTipText     =   "Configure Counters 0 and 1"
      Top             =   1080
      Width           =   630
   End
   Begin VB.Label Label7 
      AutoSize        =   -1  'True
      Caption         =   "Simulated Duration (msec) :"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   165
      Left            =   1320
      TabIndex        =   12
      Top             =   2280
      Width           =   2130
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   435
      Left            =   480
      TabIndex        =   9
      Top             =   240
      Width           =   2295
   End
   Begin VB.Label lblPrompt 
      BackColor       =   &H8000000E&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   1320
      TabIndex        =   8
      Top             =   5520
      Width           =   3135
   End
   Begin VB.Label Label3 
      Caption         =   "Difference"
      Height          =   255
      Left            =   7320
      TabIndex        =   7
      Top             =   1080
      Width           =   975
   End
   Begin VB.Label Label2 
      Caption         =   "CT1 Counts"
      Height          =   255
      Left            =   6000
      TabIndex        =   6
      Top             =   1080
      Width           =   975
   End
   Begin VB.Label Label1 
      Caption         =   "CT0 Counts"
      Height          =   255
      Left            =   4680
      TabIndex        =   5
      Top             =   1080
      Width           =   975
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H00FFFFFF&
      Caption         =   "Status"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   1320
      TabIndex        =   4
      Top             =   4920
      Width           =   3135
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim localbuf(1000) As Integer 'Local buffer to hold readings
Dim result As Long
' Tested with KPCI-3140 in Win2KSP1 with 3140-850A02 driver release
'
' used CT channel 7 to generate a 1KHz time base to the two channels of counter
' that are used for the time interval measurement.  Apply this
' external 1KHz (arbitrary value) timebase signal to the inputs of counters 0 and 1.
'
'
' the internal 40MHz time base does not allow enough time to determine much
' 16bit counter * 40MHz time base = 1.6 msec of counting...not very long.  A
' slower timebase signal allows longer times to be measured at the expense
' of resolution
'


Private Sub cmdHelp_Click()
Form2.Show
Form1.Hide
End Sub

Private Sub cmdTriggers_Click()
' Apply the start and stop pulses to the gate of channel 0 and 1
'
' get the requested duration from the form
Timer1.Interval = CSng(txtDuration.Text)
SR_DO.Res_Sta_ioValue = 1  ' set the LSB to a logic 1, e.g., START pulse
' .Res_Sta_ioValue property can host the single value to be written
SR_DO.Refresh  ' write it
Timer1.Enabled = True  ' stop pulse will be fired from this timer object
cmdTriggers.Font.Bold = False
cmdTriggers.Enabled = False
Command4.Enabled = False  ' do not allow the stop button any more
lblPrompt.Caption = "Triggering Pulses in action..."
End Sub

Private Sub Timer1_Timer()
SR_DO.Res_Sta_ioValue = 2  ' set the second bit to a logic 1, e.g., STOP pulse
SR_DO.Refresh
Timer1.Enabled = False  ' disable the timer
SR_DO.Res_Sta_ioValue = 0  ' set all bits back to logic 0 state
SR_DO.Refresh
End Sub


Private Sub Command1_Click()
Dim chan As Integer
'configure operations
' hardware mode zero....non-retrig oneshot....uses edge gating
'
For chan = 0 To 1
With DriverLINXSR1
.Req_op = DL_CONFIGURE 'configure operation for group operation
.Req_mode = DL_OTHER
.Req_subsystem = DL_CT
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = chan  ' config channels 0 and 1
.Evt_Tim_rateClock = DL_EXTERNAL   ' apply TTL signal to input of counter
.Evt_Tim_rateGate = HIEDGEGATEN
.Evt_Tim_rateMode = DL_PULSEGEN   ' mode 0
.Evt_Tim_rateOnCount = 2  ' minimum value
.Evt_Tim_rateOutput = CT_Output_Default
.Evt_Tim_ratePeriod = 65533 'initial value will be 2 when counter is read
.Evt_Tim_ratePulses = 0
.Refresh
End With
If DriverLINXSR1.Res_result <> DL_NoErr Then
MsgBox "Error Configuring the counter.  Is this a KPCI-3140 Configured as Device 0?", vbOKOnly
Exit Sub
End If
Next chan


' the onshot mode requires both a period and an onCount value.
' by trial and error, the minimum onCount value the driver will accept is 2
' this leaves no more than 65533 for the Period
' when the gate edge is detected, the counter starts from value of onCount
' and will count up to max value specified by Period
'
' once it reaches this full scale value, it will roll over and stop
Command1.Enabled = False  'disable the Configure button
Command2.Enabled = True
Command4.Enabled = False
End Sub

Private Sub Command2_Click()
'
' with group mode operations, the values from the counters can be read into a buffer
' at a high reading rate controlled by one of the 24bit interval counters.  This is quite
' similar in concept to how analog input boards make use of a clock to dictate when the data
' are acquired.
'
' This task reads the values of our previously configured counters into a buffer.  A buffer
' filled message is sent at intervals controlled by the reading rate and buffer size.

With DriverLINXSR1
.Req_op = DL_START
.Req_mode = DL_INTERRUPT   'this will be an interrupt-driven task
.Req_subsystem = DL_CT
.Evt_Tim_type = DL_RATEEVENT
.Evt_Str_type = DL_COMMAND
.Evt_Stp_type = DL_COMMAND
.Evt_Tim_rateChannel = 8   ' one of the 24bit interval timers that can pace the reading rate
' be used for pacing
.Evt_Tim_rateClock = DL_INTERNAL1 'the 40MHz timebase
.Evt_Tim_rateGate = DL_DISABLED
.Evt_Tim_rateMode = DL_RATEGEN     'Use the rate generator mode
' pick a rate at which to read the counters......this one set up for 1000Hz rate
.Evt_Tim_ratePeriod = .DLSecs2Tics(.Evt_Tim_rateChannel, 1 / 1000!)
.Evt_Tim_ratePulses = 0
.Evt_Tim_rateOnCount = 0
.Sel_chan_N = 2 'a start and stop channel will be specified
.Sel_chan_start = 0
.Sel_chan_stop = 1
.Sel_chan_format = DL_tNATIVE
.Sel_chan_simultaneousScan = True 'read both counters at the same time
.Sel_buf_N = 3 'Using multiple buffers so one can be read if the others are being written to
.Sel_buf_samples = 1000 'take 500 readings from each counter
' take care not to have the combination of ratePeriod and buf_samples such
' that the buffer_filled messages come too fast to process.....
' Windows' messaging is slow.
.Sel_buf_notify = DL_NOTIFY 'Enable buffer filled message
' display edit SR dialog from LearnDL application
'.Req_op_edit = True
'.Refresh
.Refresh
End With
If DriverLINXSR1.Res_result = DL_NoErr Then
lblPrompt.Caption = "Apply Start and Stop pulses to the GATES of the Counters."
Command2.Enabled = False
Command4.Enabled = True
cmdTriggers.Font.Bold = True
cmdTriggers.Enabled = True
Text1.Text = ""  ' blank out last reading....
Else
lblStatus.Caption = DriverLINXSR1.Message
End If
End Sub
Private Sub Command4_Click()
With DriverLINXSR1
.Req_op = DL_STOP
.Refresh
End With
lblStatus.Caption = " Timers are stopped"
Command4.Enabled = False
cmdTriggers.Enabled = False
Command2.Enabled = True
End Sub

Private Sub DriverLINXSR1_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
'Dim i As Integer
'Dim timeDiff As Integer
Dim startCT, stopCT, ElapsedTime As Long
'Beep

result = DriverLINXSR1.VBArrayBufferXfer(bufIndex, localbuf, DL_BufferToVBArray)
'When buffer fills, transfer to array

' add logic to test for negative values.....VB integers are always signed
' counter values in excess of 32768 will be negative in VB
'
' test the last values in the buffer
startCT = localbuf(998)  ' last reading from CT0
stopCT = localbuf(999)   ' last reading from CT1
If startCT < 0 Then startCT = startCT + 65535   ' cast as unsigned integer
If stopCT < 0 Then stopCT = stopCT + 65535
ElapsedTime = startCT - stopCT

'display the values on the form...
txtCT0.Text = startCT
txtCT1.Text = stopCT
txtDIFF.Text = ElapsedTime

If ElapsedTime = 0 Then lblStatus.Caption = "timers not yet started"
If ElapsedTime > 0 Then lblStatus.Caption = "timer has started"
' if stop channel is no longer at initial value of 2, then assume the stop pulse
' has occured......the reading is valid

If stopCT > 2 Then
lblStatus.Caption = " time interval measurement is complete"
Text1.Text = Str(ElapsedTime) & " msec"  'Display buffer contents
Command4_Click   ' call stop the counter
End If

' if list3 contains negative numbers then the stop channel got it's pulse
' before the start channel did

' when both the list1 and list2 no longer contain the initial value (2 in this case)
' then the difference between them is indicative of the time interval
'
' the time interval is the difference in count multiplied by the time base
' for my testing, I used external time base of 1Hz and manually applied signal to the
' gates of the counter channels to start them

' stop channel must get it's pulse before start channel reaches maximum count

'

End Sub

Private Sub DriverLINXSR1_DataLost(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Long, bufElement As Long)
Debug.Print "data lost"
End Sub

Private Sub Form_Load()
Timer1.Enabled = False
With DriverLINXSR1
.Req_DLL_name = "kpci3140$"   ' load only the kpci3140 driver
.Req_device = 0
.Req_op = DL_INITIALIZE
.Req_mode = DL_OTHER
.Req_subsystem = DL_DEVICE
.Refresh
End With
If DriverLINXSR1.Res_result = DL_NoErr Then
' if successful in opening the driver....
'set other controls to same driver name, device number
SR_SqWave.Req_DLL_name = DriverLINXSR1.Req_DLL_name
SR_SqWave.Req_device = DriverLINXSR1.Req_device
SR_DO.Req_DLL_name = DriverLINXSR1.Req_DLL_name
SR_DO.Req_device = DriverLINXSR1.Req_device
' set up a digital channel for output mode to be used to simulate start/stop pulses
SetupDigitalOutput
' set up a CT channel to generate a square wave that can be our timebase signal
SetupSqWaveTimebase
Command1.Enabled = True
Else
DriverLINXSR1.Req_op = DL_MESSAGEBOX
DriverLINXSR1.Refresh
End If
End Sub

Sub showmessage(sr As Control)
sr.Req_op = DL_MESSAGEBOX
sr.Refresh
End Sub

Private Sub Form_Unload(Cancel As Integer)
With DriverLINXSR1
.Req_op = DL_STOP  ' just in case stop any active tasks
.Refresh
.Req_DLL_name = ""  ' unload driver from memory
End With
End Sub

'
' other TODO:
' 1.  could use the edge detection feature of the digital ports of port D to know when the start
'     or stop pulse have arrived
' 2.  could use the edge detection feature of the digital ports of port D to know if the
'     start counter reaches TC (it will change state)
' 3.  Add another SR control to make use of digital bits to simulate start/stop pulses.  For
'     now have used AIOPanel to exercise the bits.


Private Sub SetupSqWaveTimebase()
' set up and start a CT channel generating a square wave signal
' that will be used as a timebase signal to the two edge triggerd counting
' CT channels.  Must use a jumper wire to connect the output of this sqwave
' channel to the inputs of each of the counting channels
Dim Period As Single
Period = 0.001  ' 1msec period = 1KHz square wave
With SR_SqWave
.Req_op = DL_START
.Req_subsystem = DL_CT
.Req_mode = DL_POLLED
.Evt_Str_type = DL_COMMAND
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = 7  ' channels 0 and 1 used for triggered counting
' so channels 2 through 7 are available to generate the square wave
.Evt_Tim_rateClock = DL_INTERNAL1
.Evt_Tim_rateGate = DL_DISABLED
.Evt_Tim_rateMode = DL_SQWAVE
.Evt_Tim_rateOutput = CT_Output_Default
.Evt_Tim_ratePeriod = .DLSecs2Tics(.Evt_Tim_rateChannel, Period)
.Evt_Tim_ratePulses = 0
.Evt_Stp_type = DL_NULLEVENT
.Refresh
End With
showmessage SR_SqWave
' signal will be available at TB30 of STP-3140.  Connect to inputs of the counting channels
' at TB 2 and TB 6 on the STP-3140
End Sub

Private Sub SetupDigitalOutput()
' first need to configure the digital channe for output mode
With SR_DO
.Req_subsystem = DL_DO  ' assign the channel the DL_DO subsystem
.Req_mode = DL_OTHER
.Req_op = DL_CONFIGURE
.Evt_Tim_type = DL_DIOSETUP
.Evt_Tim_dioChannel = 0
.Evt_Tim_dioMode = DL_DIO_BASIC
.Refresh
End With
' now set up a polled mode DO task
With SR_DO
' Request Group
.Req_op = DL_START
.Req_mode = DL_POLLED  ' no pacing clock involved
.Req_subsystem = DL_DO
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically
.Evt_Tim_type = DL_NULLEVENT  ' no timing for Polled mode
' Select Group
.Sel_buf_N = 0                 ' no buffers used
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 1                ' one channel
.Sel_chan_start = 0            ' is is channel 0
.Res_Sta_ioValue = 0           ' set all 8 bits to a logic 0 state
.Refresh
End With
End Sub
Private Sub cmdExit_Click()
' stop any active tasks that might be active....
With SR_SqWave
.Req_op = DL_STOP
.Refresh
End With
With DriverLINXSR1
.Req_op = DL_STOP
.Refresh
' the SR_DO task is polled so not worrying about stopping that task
' unload drivers for all three objects
DriverLINXSR1.Req_DLL_name = ""
SR_SqWave.Req_DLL_name = ""
SR_DO.Req_DLL_name = ""
End  ' exit this program
End With
End Sub
